var curTV;
var curVolume;
var curComp;
var curRatio;
var Space;
var tmpClass;
var table;
var maxVolume;

var MODE_NAME = new Array();
MODE_NAME[0] = 'H.264 (16:9)';
MODE_NAME[1] = 'H.264 (4:3)';
MODE_NAME[2] = 'JPEG (16:9)';
MODE_NAME[3] = 'JPEG (4:3)';

var MEDIA_VOLUME = new Array();
MEDIA_VOLUME[0] = 80;
MEDIA_VOLUME[1] = 2;

var H264_BPS = new Array();
H264_BPS[0] = new Array();
H264_BPS[0][0] = new Array();
H264_BPS[0][0][0] = '8000|7000|6000|5000|4000';
H264_BPS[0][0][1] = '7250|6250|5250|4250|3000';
H264_BPS[0][1] = new Array();
H264_BPS[0][1][0] = '6600|5600|4600|3600|2500';
H264_BPS[0][1][1] = '5900|5000|4100|3200|2200';
H264_BPS[0][2] = new Array();
H264_BPS[0][2][0] = '5000|4100|3200|2300|1300';
H264_BPS[0][2][1] = '4000|3280|2550|1830|1100';
H264_BPS[0][3] = new Array();
H264_BPS[0][3][0] = '1800|1480|1170|860|550';
H264_BPS[0][3][1] = '1600|1330|1050|780|500';
H264_BPS[0][4] = new Array();
H264_BPS[0][4][0] = '500|420|350|280|200';
H264_BPS[0][4][1] = '450|380|320|250|180';
H264_BPS[1] = new Array();
H264_BPS[1][0] = new Array();
H264_BPS[1][0][0] = '6600|5600|4600|3600|2500';
H264_BPS[1][0][1] = '5900|5000|4100|3200|2200';
H264_BPS[1][1] = new Array();
H264_BPS[1][1][0] = '3500|2870|2240|1600|980';
H264_BPS[1][1][1] = '3200|2620|2050|1460|880';
H264_BPS[1][2] = new Array();
H264_BPS[1][2][0] = '1000|830|650|480|300';
H264_BPS[1][2][1] = '900|740|590|430|270';

var JPEG_KB = new Array();
JPEG_KB[0] = new Array();
JPEG_KB[0][0] = '310|268|224|180|135';
JPEG_KB[0][1] = '150|134|117|90|60';
JPEG_KB[0][2] = '88|78|61|47|31';
JPEG_KB[0][3] = '56|50|39|30|20';
JPEG_KB[1] = new Array();
JPEG_KB[1][0] = '540|455|370|285|200';
JPEG_KB[1][1] = '270|230|190|150|110';
JPEG_KB[1][2] = '200|178|156|120|80';
JPEG_KB[1][3] = '143|128|100|77|51';
JPEG_KB[1][4] = '88|78|61|47|31';
JPEG_KB[1][5] = '56|50|39|30|20';
JPEG_KB[1][6] = '35|26|21|15|11';

var JPEG_MAX_RATE_PAL = new Array();
JPEG_MAX_RATE_PAL[0] = new Array();
JPEG_MAX_RATE_PAL[0][0] = '5';
JPEG_MAX_RATE_PAL[0][1] = '8';
JPEG_MAX_RATE_PAL[0][2] = '12.5';
JPEG_MAX_RATE_PAL[0][3] = '25';
JPEG_MAX_RATE_PAL[1] = new Array();
JPEG_MAX_RATE_PAL[1][0] = '2.5';
JPEG_MAX_RATE_PAL[1][1] = '5';
JPEG_MAX_RATE_PAL[1][2] = '8';
JPEG_MAX_RATE_PAL[1][3] = '8';
JPEG_MAX_RATE_PAL[1][4] = '12.5';
JPEG_MAX_RATE_PAL[1][5] = '25';
JPEG_MAX_RATE_PAL[1][6] = '25';

var JPEG_MAX_RATE_NTSC = new Array();
JPEG_MAX_RATE_NTSC[0] = new Array();
JPEG_MAX_RATE_NTSC[0][0] = '5';
JPEG_MAX_RATE_NTSC[0][1] = '10';
JPEG_MAX_RATE_NTSC[0][2] = '15';
JPEG_MAX_RATE_NTSC[0][3] = '30';
JPEG_MAX_RATE_NTSC[1] = new Array();
JPEG_MAX_RATE_NTSC[1][0] = '3';
JPEG_MAX_RATE_NTSC[1][1] = '5';
JPEG_MAX_RATE_NTSC[1][2] = '10';
JPEG_MAX_RATE_NTSC[1][3] = '10';
JPEG_MAX_RATE_NTSC[1][4] = '15';
JPEG_MAX_RATE_NTSC[1][5] = '30';
JPEG_MAX_RATE_NTSC[1][6] = '30';

var H264_RATE_PAL = new Array();
H264_RATE_PAL[0] = '25.0';
H264_RATE_PAL[1] = '12.5';

var H264_RATE_NTSC = new Array();
H264_RATE_NTSC[0] = '30.0';
H264_RATE_NTSC[1] = '15.0';

var JPEG_RATE_PAL = new Array();
JPEG_RATE_PAL[0] = '25.0';
JPEG_RATE_PAL[1] = '12.5';
JPEG_RATE_PAL[2] = '8.0';
JPEG_RATE_PAL[3] = '5.0';
JPEG_RATE_PAL[4] = '2.5';
JPEG_RATE_PAL[5] = '1.0';
JPEG_RATE_PAL[6] = '0.5';
JPEG_RATE_PAL[7] = '0.2';
JPEG_RATE_PAL[8] = '0.1';

var JPEG_RATE_NTSC = new Array();
JPEG_RATE_NTSC[0] = '30.0';
JPEG_RATE_NTSC[1] = '15.0';
JPEG_RATE_NTSC[2] = '10.0';
JPEG_RATE_NTSC[3] = '5.0';
JPEG_RATE_NTSC[4] = '3.0';
JPEG_RATE_NTSC[5] = '1.0';
JPEG_RATE_NTSC[6] = '0.5';
JPEG_RATE_NTSC[7] = '0.2';
JPEG_RATE_NTSC[8] = '0.1';

var H264_RESOLUTION = new Array();
H264_RESOLUTION[0] = new Array();
H264_RESOLUTION[0][0] = '1920|1080p';
H264_RESOLUTION[0][1] = '1280|720p';
H264_RESOLUTION[0][2] = '960|540p';
H264_RESOLUTION[0][3] = '640|360p';
H264_RESOLUTION[0][4] = '320|240p';
H264_RESOLUTION[1] = new Array();
H264_RESOLUTION[1][0] = '1080|720p|1080|864p';
H264_RESOLUTION[1][1] = '720|480p|720|576p';
H264_RESOLUTION[1][2] = '360|240p|360|288p';

var JPEG_RESOLUTION = new Array();
JPEG_RESOLUTION[0] = new Array();
JPEG_RESOLUTION[0][0] = '1920|1080';
JPEG_RESOLUTION[0][1] = '1280|720';
JPEG_RESOLUTION[0][2] = '1024|576';
JPEG_RESOLUTION[0][3] = '640|360';
JPEG_RESOLUTION[1] = new Array();
JPEG_RESOLUTION[1][0] = '2288|1712';
JPEG_RESOLUTION[1][1] = '1600|1200';
JPEG_RESOLUTION[1][2] = '1280|960';
JPEG_RESOLUTION[1][3] = '1024|768';
JPEG_RESOLUTION[1][4] = '800|600';
JPEG_RESOLUTION[1][5] = '640|480';
JPEG_RESOLUTION[1][6] = '320|240';

function getSpace(ColWidth,CharWidth) {
  var www = document.body.clientWidth;
  if(www==0) {www = document.documentElement.clientWidth; }
  Space = (www * ColWidth / 100 - CharWidth) / 2;
}

function calcVolume() {
  maxVolume = MEDIA_VOLUME[curVolume] * 1000 * 1000 * 1000 - 251 * 1024 * 1024;
}

function MM_Over(obj) {
  obj.style.cursor = 'hand';
  tmpClass = obj.className;
  obj.className = 'aaa';
}

function MM_Out(obj) {
  obj.style.cursor = 'default';
  obj.className = tmpClass;
}

function MM_Update() {
  var str;
  var tmp;
  document.getElementById('_tv0').className = 'bbb';
  document.getElementById('_tv1').className = 'bbb';
  document.getElementById('_md0').className = 'bbb';
  document.getElementById('_md1').className = 'bbb';
  document.getElementById('_cmp0').className = 'bbb';
  document.getElementById('_cmp1').className = 'bbb';
  document.getElementById('_cmp2').className = 'bbb';
  document.getElementById('_cmp3').className = 'bbb';
  str = '_tv' + curTV;
  document.getElementById(str).className = 'sss';
  str = '_md' + curVolume;
  document.getElementById(str).className = 'sss';
  tmp = (2 * curComp) + curRatio;
  str = '_cmp' + tmp;
  document.getElementById(str).className = 'sss';
  tmpClass= 'sss';
}

function decimalAlign(num, decimal) {
  decimalChar = "";
  alignNumber = Math.pow(10, decimal);
  result = Math.round(num * alignNumber) / alignNumber;

  result_str = String(result);
  for (i = 1; i <= decimal; i++) {
    decimalChar += "0";
  }
  if (result_str.indexOf(".") != -1) {
    a = result_str.split(".")[0];
    b = result_str.split(".")[1] + decimalChar;
    result_str = a + "." + b.substring(0, decimal);
  } else {
    a = result_str.split(".")[0];
    if (decimal != 0) {
      result_str = a + "." + decimalChar;
    } else {
      result_str = a;
    }
  }
  return(result_str);
}

function CalcH264(p,r,c,rate) {
  var x = SplitVal(H264_BPS[curRatio][p][r], c);
  var hrs = maxVolume * 8 / (x * 1024 + 48 * 8 * rate) / 60 / 60 * 2 / 3;
  hrs = Math.round(hrs * 10) / 10;
  return decimalAlign(hrs, 1);
}

function CalcJPEG(p,r,c) {
  var x = SplitVal(JPEG_KB[curRatio][p], c);
  var hrs = maxVolume / ((x * 1024 + 48) * r * 60) / 60;
  hrs = Math.round(hrs * 10) / 10;
  return decimalAlign(hrs, 1);
}

function drawTable(tv,md,cmp,ratio) {
  if(eval(tv)>=0) {curTV = tv;}
  if(eval(md)>=0) {curVolume = md;}
  if(eval(cmp)>=0) {curComp = cmp;}
  if(eval(ratio)>=0) {curRatio = ratio;}
  MM_Update();
  getSpace(14,45);
  calcVolume();
  drawTableHeader();
  drawTableContents();
  drawTableTailer();
}

function drawTableHeader() {
  var item_0 = document.getElementById('item_0').innerHTML;
  var item_1 = document.getElementById('item_1').innerHTML;
  var item_2 = document.getElementById('item_2').innerHTML;
  var item_3 = document.getElementById('item_3').innerHTML;
  var item_4 = document.getElementById('item_4').innerHTML;
  var item_5 = document.getElementById('item_5').innerHTML;
  var item_6 = document.getElementById('item_6').innerHTML;
  var item_7 = document.getElementById('item_7').innerHTML;
  table = '<TABLE id=full cellSpacing=1 cellPadding=3>\n';
  table += '<col width=16%>\n';
  table += '<col width=14%>\n';
  table += '<col width=14%>\n';
  table += '<col width=14%>\n';
  table += '<col width=14%>\n';
  table += '<col width=14%>\n';
  table += '<col width=14%>\n';
  table += '<TBODY>\n';
  table += '<TR>\n';
  table += '<TH colspan=2>\n';
  table += item_0;
  table += '</TH>\n';
  table += '<TH rowspan=2>\n';
  table += item_3;
  table += '</TH>\n';
  table += '<TH rowspan=2>\n';
  table += item_4;
  table += '</TH>\n';
  table += '<TH rowspan=2>\n';
  table += item_5;
  table += '</TH>\n';
  table += '<TH rowspan=2>\n';
  table += item_6;
  table += '</TH>\n';
  table += '<TH rowspan=2>\n';
  table += item_7;
  table += '</TH></TR>\n';
  table += '<TR>\n';
  table += '<TH>\n';
  table += item_1;
  table += '</TH>\n';
  table += '<TH>\n';
  table += item_2;
  table += '</TH></TR>\n';
}

function drawTableTailer() {
	var layer = document.getElementById('rate_table');
  table += '</TBODY></TABLE>\n';
	layer.innerHTML = table;
}

function SplitVal(mstr,idx) {
  xxx = mstr.split("|");
  return xxx[idx];
}

function getStartIndex(mRateList, mMaxRate) {
  var mIndex;
  for(var i=0; mRateList.length; i++) {
    if(eval(mRateList[i]) <= eval(mMaxRate)) {
      mIndex = i;
      break;
    }
  }
  return mIndex;
}

function drawTableContents() {
  var REC_RATE;
  var RATE_START;
  var ROW_SPAN;
  var RES_LIST;
  var RATE_LIST;
  var MAX_LIST;
  if(curTV==0) {
    MAX_LIST = JPEG_MAX_RATE_PAL;
  } else {
    MAX_LIST = JPEG_MAX_RATE_NTSC;
  }
  if(curComp==0) {
    RES_LIST = H264_RESOLUTION[curRatio];
  } else {
    RES_LIST = JPEG_RESOLUTION[curRatio];
  }
  if(curComp==0) {
    if(curTV==0) {
      RATE_LIST = H264_RATE_PAL;
    } else {
      RATE_LIST = H264_RATE_NTSC;
    }
  } else {
    if(curTV==0) {
      RATE_LIST = JPEG_RATE_PAL;
    } else {
      RATE_LIST = JPEG_RATE_NTSC;
    }
  }
  for(var i=0; i<RES_LIST.length; i++) {
    RATE_START = 0;
    ROW_SPAN = RATE_LIST.length;
    if(curComp==1) {
      RATE_START = getStartIndex(RATE_LIST, MAX_LIST[curRatio][i]);
      ROW_SPAN = ROW_SPAN - RATE_START;
    }
    table += '<TR>\n';
    table += '<TH align="center"';
    table += ' rowspan=';
    table += ROW_SPAN;
    table += '>';
    if((curTV==0) && (curRatio==1) && (curComp==0)) {
      table += SplitVal(RES_LIST[i], 2);
      table += '&times;';
      table += SplitVal(RES_LIST[i], 3);
    } else {
      table += SplitVal(RES_LIST[i], 0);
      table += '&times;';
      table += SplitVal(RES_LIST[i], 1);
    }
    table += '</TH>';
    for(var p=RATE_START; p<RATE_LIST.length; p++) {
      if(p > RATE_START) {
        table += '<TR>';
      }
      table += '<TH>';
      table += RATE_LIST[p];
      table += '</TH>';
      REC_RATE = RATE_LIST[p];
      for(var m=0; m<5; m++) {
        table += '<TD class=rate>';
        if(curComp==0) {
          table += CalcH264(i,p,m,REC_RATE);
        } else {
          table += CalcJPEG(i,RATE_LIST[p],m);
        }
        table += '<span style="margin-right:';
        table += Space;
        table += '"></span></TD>';
      }
      table += '</TR>\n';
    }
  }
}

function drawTargetsizeTable() {
  getSpace(12,50);
  drawTargetHeader();
  drawTargetsizeList();
  drawTableTailer();
}

function drawTargetHeader() {
  var item_0 = document.getElementById('item_0').innerHTML;
  var item_1 = document.getElementById('item_1').innerHTML;
  var item_2 = document.getElementById('item_2').innerHTML;
  var item_3 = document.getElementById('item_3').innerHTML;
  var item_4 = document.getElementById('item_4').innerHTML;
  var item_5 = document.getElementById('item_5').innerHTML;
  var item_6 = document.getElementById('item_6').innerHTML;
  var item_7 = document.getElementById('item_7').innerHTML;
  table = '<TABLE id=full cellSpacing=1 cellPadding=3>\n';
  table += '<col width=auto>\n';
  table += '<col width=auto>\n';
  table += '<col width=auto>\n';
  table += '<col width=12%>\n';
  table += '<col width=12%>\n';
  table += '<col width=12%>\n';
  table += '<col width=12%>\n';
  table += '<col width=12%>\n';
  table += '<TBODY>\n';
  table += '<TR>\n';
  table += '<TH rowspan=2>&nbsp;</TH>\n';
  table += '<TH colspan=2>\n';
  table += item_0;
  table += '</TH>\n';
  table += '<TH rowspan=2>\n';
  table += item_3;
  table += '</TH>\n';
  table += '<TH rowspan=2>\n';
  table += item_4;
  table += '</TH>\n';
  table += '<TH rowspan=2>\n';
  table += item_5;
  table += '</TH>\n';
  table += '<TH rowspan=2>\n';
  table += item_6;
  table += '</TH>\n';
  table += '<TH rowspan=2>\n';
  table += item_7;
  table += '</TH></TR>\n';
  table += '<TR>\n';
  table += '<TH>\n';
  table += item_1;
  table += '</TH>\n';
  table += '<TH>\n';
  table += item_2;
  table += '</TH></TR>\n';
}

function drawTargetsizeList() {
  var ROWS;
  var RATE_START;
  var ROW_SPAN;
  var RES_LIST;
  var RATE_LIST;
  for (var mode=0; mode < MODE_NAME.length; mode++) {
    switch(mode) {
      case 0:  RES_LIST = H264_RESOLUTION[0];
               ROWS = RES_LIST.length * 2;
               break;
      case 1:  RES_LIST = H264_RESOLUTION[1];
               ROWS = RES_LIST.length * 2;
               break;
      case 2:  RES_LIST = JPEG_RESOLUTION[0];
               ROWS = RES_LIST.length;
               break;
      default: RES_LIST = JPEG_RESOLUTION[1];
               ROWS = RES_LIST.length;
               break;
    }
    table += '<TR><TH rowspan=';
    table += ROWS;
    table += '>';
    table += MODE_NAME[mode];
    table += '</TH>';
    for(var i=0; i<RES_LIST.length; i++) {
      ROW_SPAN = H264_RATE_PAL.length;
      if(i>0) {
        table += '<TR>\n';
      }
      if(mode < 2) {
        table += '<TH rowspan=';
        table += H264_RATE_PAL.length;
        table += '>';
        table += SplitVal(RES_LIST[i], 0);
        table += '&times;';
        table += SplitVal(RES_LIST[i], 1);
        if(mode==1) {
          table += '<BR>(';
          table += SplitVal(RES_LIST[i], 2);
          table += '&times;';
          table += SplitVal(RES_LIST[i], 3);
          table += ')';
        }
        table += '</TH>';
        for(var p=0; p<H264_RATE_PAL.length; p++) {
          if(p > 0) {
            table += '<TR>';
          }
          table += '<TH>';
          table += H264_RATE_PAL[p];
          table += ' (';
          table += H264_RATE_NTSC[p];
          table += ')';
          table += '</TH>';
          for(var m=0; m<5; m++) {
            table += '<TD class=rate>';
            table += SplitVal(H264_BPS[mode % 2][i][p], m);
            table += '<span style="margin-right:';
            table += Space;
            table += '"></span></TD>';
          }
          table += '</TR>\n';
        }
      } else {
        table += '<TH>';
        table += SplitVal(RES_LIST[i], 0);
        table += '&times;';
        table += SplitVal(RES_LIST[i], 1);
        table += '</TH><TH>&minus;</TH>';
        for(var m=0; m<5; m++) {
          table += '<TD class=rate>';
          table += SplitVal(JPEG_KB[mode % 2][i], m);
          table += '<span style="margin-right:';
          table += Space;
          table += '"></span></TD>';
        }
        table += '</TR>\n';
      }
    }
  }
}


